Assets = 
{
	Asset("IMAGE", "minimap/shadow_knight.tex"),
	Asset("ATLAS", "minimap/shadow_knight.xml"),
	Asset("IMAGE", "minimap/shadow_knight_2.tex"),
	Asset("ATLAS", "minimap/shadow_knight_2.xml"),
	Asset("IMAGE", "minimap/shadow_knight_3.tex"),
	Asset("ATLAS", "minimap/shadow_knight_3.xml"),	
	Asset("IMAGE", "minimap/shadow_rook.tex"),
	Asset("ATLAS", "minimap/shadow_rook.xml"),
	Asset("IMAGE", "minimap/shadow_rook_2.tex"),
	Asset("ATLAS", "minimap/shadow_rook_2.xml"),
	Asset("IMAGE", "minimap/shadow_rook_3.tex"),
	Asset("ATLAS", "minimap/shadow_rook_3.xml"),	
	Asset("IMAGE", "minimap/shadow_bishop.tex"),
	Asset("ATLAS", "minimap/shadow_bishop.xml"),
	Asset("IMAGE", "minimap/shadow_bishop_2.tex"),
	Asset("ATLAS", "minimap/shadow_bishop_2.xml"),
	Asset("IMAGE", "minimap/shadow_bishop_3.tex"),
	Asset("ATLAS", "minimap/shadow_bishop_3.xml"),
}

PrefabFiles = 
{
	"shadow_pieces",
	"shadowheart",
}

require = GLOBAL.require
local TUNING = GLOBAL.TUNING
local GetPlayer = GLOBAL.GetPlayer
local Combat = require "components/combat"
local follower = require "components/follower"
local harvestable = require "components/harvestable"
local ccanattack = Combat.CanAttack
local GetPlayer = GLOBAL.GetPlayer
local STRINGS = GLOBAL.STRINGS
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local TECH = GLOBAL.TECH
local ACTIONS = GLOBAL.ACTIONS
local Vector3 = GLOBAL.Vector3
local distsq = GLOBAL.distsq
local GetWorld = GLOBAL.GetWorld
local Prefabs = GLOBAL.Prefabs
local Transform = GLOBAL.Transform
local Physics = GLOBAL.Physics
local AnimState = GLOBAL.AnimState
local FRAMES = GLOBAL.FRAMES
local DEGREES = GLOBAL.DEGREES
local SpawnPrefab = GLOBAL.SpawnPrefab
local TheCamera = GLOBAL.TheCamera
local seg_time = 30
local day_segs = 10
local dusk_segs = 4
local night_segs = 2
local day_time = seg_time * day_segs
local dusk_time = seg_time * dusk_segs
local night_time = seg_time * night_segs
local total_day_time = seg_time*16
local TheSim = GLOBAL.TheSim
local SpawnPrefab = GLOBAL.SpawnPrefab
local GetSeasonManager = GLOBAL.GetSeasonManager
local SEASONS = GLOBAL.SEASONS
local GetClock = GLOBAL.GetClock
local GetWorld = GLOBAL.GetWorld

AddMinimapAtlas("minimap/shadow_knight.xml")
AddMinimapAtlas("minimap/shadow_knight_2.xml")
AddMinimapAtlas("minimap/shadow_knight_3.xml")
AddMinimapAtlas("minimap/shadow_rook.xml")
AddMinimapAtlas("minimap/shadow_rook_2.xml")
AddMinimapAtlas("minimap/shadow_rook_3.xml")
AddMinimapAtlas("minimap/shadow_bishop.xml")
AddMinimapAtlas("minimap/shadow_bishop_2.xml")
AddMinimapAtlas("minimap/shadow_bishop_3.xml")

GLOBAL.TUNING.SHADOW_MOONEVENT_SPAWN = GetModConfigData("moon_event")
GLOBAL.TUNING.SHADOW_MOONEVENT_FIRSTDAY = GetModConfigData("moon_event_start_day")
GLOBAL.TUNING.SHADOW_SPAWN_FREQUENCE = GetModConfigData("shadow_spawn_frequence")
GLOBAL.TUNING.SHADOW_LEVELUP_CHANCE = GetModConfigData("shadow_level_up_chance")
GLOBAL.TUNING.SHADOW_WANDER_TIME = total_day_time * 2

function ROGComponents(inst)
	if not inst.components.shadowpieces then
		inst:AddComponent("shadowpieces")
	end
end

function SWComponents(inst)
	if not inst.components.shadowpiecessw then
		inst:AddComponent("shadowpiecessw")
	end
end

if GLOBAL.IsDLCInstalled(GLOBAL.CAPY_DLC) and GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC) then
	AddPrefabPostInit("shipwrecked",SWComponents)
else
	AddPrefabPostInit("forest",ROGComponents)
end